connector BondPort//Base class 
 Real e;
 Real f;
end BondPort;

connector SignalPort//Base class 
 Real s;
end SignalPort;

class Node1//SeSf
 BondPort Port3;
 parameter  Real 	Se = 0;
equation
 Port3.e = Se;
 Port3.f = 1;
end Node1;

class Node5//J0
 BondPort Port15;
 BondPort Port19;
 BondPort Port27;
equation
 Port15.e = Port19.e;
 Port19.e = Port27.e;
 -Port15.f+Port19.f+Port27.f = 0;
end Node5;

class Node6//J1
 BondPort Port18;
 BondPort Port22;
 BondPort Port25;
equation
 Port18.f = Port22.f;
 Port22.f = Port25.f;
 Port18.e-Port22.e-Port25.e = 0;
end Node6;

class Node7//R
 BondPort Port24;
 parameter  Real 	R = 20000;
equation
 Port24.e = R * Port24.f;
end Node7;

class Node8//C
 BondPort Port21;
 parameter  Real 	C = 1/10000;
 Real 	q;
equation
 Port21.f = der(q);
 q = C * Port21.e;
end Node8;

class Node140//J1
 BondPort Port2;
 BondPort Port155;
 BondPort Port157;
 BondPort Port201;
equation
 -Port155.e+Port157.e+Port201.e+Port2.e = 0;
 Port155.f = Port157.f;
 Port157.f = Port201.f;
 Port201.f = Port2.f;
end Node140;

class Node141//J0
 BondPort Port158;
 BondPort Port182;
 BondPort Port303;
equation
 Port158.e = Port182.e;
 Port182.e = Port303.e;
 +Port158.f+Port182.f-Port303.f = 0;
end Node141;

class Node143//J0
 BondPort Port10;
 BondPort Port166;
 BondPort Port173;
equation
 -Port166.f+Port173.f+Port10.f = 0;
 Port166.e = Port173.e;
 Port173.e = Port10.e;
end Node143;

class Node144//I
 BondPort Port154;
 parameter  Real 	I = 250;
 Real 	p;
equation
 Port154.e = der(p);
 p = I * Port154.f;
end Node144;

class Node146//J1
 BondPort Port181;
 BondPort Port185;
 BondPort Port245;
equation
 Port181.f = Port185.f;
 Port185.f = Port245.f;
 Port181.e-Port185.e-Port245.e = 0;
end Node146;

class Node147//C
 BondPort Port184;
 parameter  Real 	C = 1/10000;
 Real 	q;
equation
 Port184.f = der(q);
 q = C * Port184.e;
end Node147;

class Node150//R
 BondPort Port178;
 parameter  Real 	R = 10000;
equation
 Port178.e = R * Port178.f;
end Node150;

class Node151//J1
 BondPort Port172;
 BondPort Port179;
 BondPort Port249;
equation
 Port172.f = Port179.f;
 Port179.f = Port249.f;
 Port172.e-Port179.e-Port249.e = 0;
end Node151;

class Node152//MSf
 BondPort Port167;
 SignalPort Port169;
equation
 Port167.f = Port169.s;
end Node152;

class Node153//Function
 SignalPort Port170;
equation
 Port170.s=if time<=0.5 then 0 else 0.1;
end Node153;

class Node196//I
 BondPort Port300;
 parameter  Real 	I = 30;
 Real 	p;
equation
 Port300.e = der(p);
 p = I * Port300.f;
end Node196;

class Node200//Se
 BondPort Port202;
 parameter  Real 	Se = 250*9.81;
equation
 Port202.e = Se;
end Node200;

class Node243//R
 BondPort Port244;
 parameter  Real 	R = 1000;
equation
 Port244.e = R * Port244.f;
end Node243;

class Node247//DeDf
 BondPort Port248;
end Node247;

class Node255//R
 BondPort Port367;
 parameter  Real 	R = 1000000;
equation
 Port367.e = R * Port367.f;
end Node255;

class Node256//C
 BondPort Port370;
 parameter  Real 	C = 1/10000;
 Real 	q;
equation
 Port370.f = der(q);
 q = C * Port370.e;
end Node256;

class Node257//I
 BondPort Port411;
 parameter  Real 	I = 10;
 Real 	p;
equation
 Port411.e = der(p);
 p = I * Port411.f;
end Node257;

class Node296//J1
 BondPort Port301;
 BondPort Port304;
 BondPort Port316;
equation
 Port301.f = Port304.f;
 Port304.f = Port316.f;
 -Port301.e-Port304.e+Port316.e = 0;
end Node296;

class Node309//J0
 BondPort Port317;
 BondPort Port365;
 BondPort Port414;
equation
 Port317.e = Port365.e;
 Port365.e = Port414.e;
 +Port317.f+Port365.f-Port414.f = 0;
end Node309;

class Node363//J1
 BondPort Port364;
 BondPort Port368;
 BondPort Port371;
equation
 Port364.f = Port368.f;
 Port368.f = Port371.f;
 Port364.e-Port368.e-Port371.e = 0;
end Node363;

class Node383//J1
 BondPort Port408;
 BondPort Port412;
 BondPort Port415;
equation
 Port408.f = Port412.f;
 Port412.f = Port415.f;
 Port408.e-Port412.e-Port415.e = 0;
end Node383;

class Node384//J0
 BondPort Port400;
 BondPort Port409;
 BondPort Port448;
equation
 Port400.e = Port409.e;
 Port409.e = Port448.e;
 +Port400.f+Port409.f-Port448.f = 0;
end Node384;

class Node386//J1
 BondPort Port399;
 BondPort Port403;
 BondPort Port406;
equation
 Port399.f = Port403.f;
 Port403.f = Port406.f;
 Port399.e-Port403.e-Port406.e = 0;
end Node386;

class Node387//R
 BondPort Port402;
 parameter  Real 	R = 1000000;
equation
 Port402.e = R * Port402.f;
end Node387;

class Node388//C
 BondPort Port405;
 parameter  Real 	C = 1/10000;
 Real 	q;
equation
 Port405.f = der(q);
 q = C * Port405.e;
end Node388;

class Node389//I
 BondPort Port445;
 parameter  Real 	I = 10;
 Real 	p;
equation
 Port445.e = der(p);
 p = I * Port445.f;
end Node389;

class Node417//J1
 BondPort Port442;
 BondPort Port446;
 BondPort Port449;
equation
 Port442.f = Port446.f;
 Port446.f = Port449.f;
 Port442.e-Port446.e-Port449.e = 0;
end Node417;

class Node418//J0
 BondPort Port434;
 BondPort Port443;
 BondPort Port482;
equation
 Port434.e = Port443.e;
 Port443.e = Port482.e;
 +Port434.f+Port443.f-Port482.f = 0;
end Node418;

class Node420//J1
 BondPort Port433;
 BondPort Port437;
 BondPort Port440;
equation
 Port433.f = Port437.f;
 Port437.f = Port440.f;
 Port433.e-Port437.e-Port440.e = 0;
end Node420;

class Node421//R
 BondPort Port436;
 parameter  Real 	R = 1000000;
equation
 Port436.e = R * Port436.f;
end Node421;

class Node422//C
 BondPort Port439;
 parameter  Real 	C = 1/10000;
 Real 	q;
equation
 Port439.f = der(q);
 q = C * Port439.e;
end Node422;

class Node423//I
 BondPort Port479;
 parameter  Real 	I = 10;
 Real 	p;
equation
 Port479.e = der(p);
 p = I * Port479.f;
end Node423;

class Node451//J0
 BondPort Port12;
 BondPort Port468;
 BondPort Port477;
equation
 +Port468.f+Port477.f-Port12.f = 0;
 Port468.e = Port477.e;
 Port477.e = Port12.e;
end Node451;

class Node452//J1
 BondPort Port9;
 BondPort Port13;
 BondPort Port16;
equation
 Port9.f = Port13.f;
 Port13.f = Port16.f;
 Port9.e-Port13.e-Port16.e = 0;
end Node452;

class Node453//J1
 BondPort Port467;
 BondPort Port471;
 BondPort Port474;
equation
 Port467.f = Port471.f;
 Port471.f = Port474.f;
 Port467.e-Port471.e-Port474.e = 0;
end Node453;

class Node454//R
 BondPort Port470;
 parameter  Real 	R = 1000000;
equation
 Port470.e = R * Port470.f;
end Node454;

class Node455//C
 BondPort Port473;
 parameter  Real 	C = 1/10000;
 Real 	q;
equation
 Port473.f = der(q);
 q = C * Port473.e;
end Node455;

class Node456//I
 BondPort Port461;
 parameter  Real 	I = 10;
 Real 	p;
equation
 Port461.e = der(p);
 p = I * Port461.f;
end Node456;

class Node457//J1
 BondPort Port476;
 BondPort Port480;
 BondPort Port483;
equation
 Port476.f = Port480.f;
 Port480.f = Port483.f;
 Port476.e-Port480.e-Port483.e = 0;
end Node457;

model modele53a_4RC
Node1 sesf_1;
Node5 j0_5;
Node6 j1_36;
Node7 r_7;
Node8 c_8;
Node140 j1_0;
Node141 j0_1;
Node143 j0_3;
Node144 i_4;
Node146 j1_6;
Node147 c_7;
Node150 r_11;
Node151 j1_11;
Node152 msf_12;
Node153 function_13;
Node196 i_14;
Node200 se_15;
Node243 r_0;
Node247 dedf_1;
Node255 r_4;
Node256 c_5;
Node257 i_6;
Node296 j1_2;
Node309 j0_6;
Node363 j1_20;
Node383 j1_25;
Node384 j0_25;
Node386 j1_26;
Node387 r_25;
Node388 c_25;
Node389 i_25;
Node417 j1_27;
Node418 j0_26;
Node420 j1_28;
Node421 r_26;
Node422 c_26;
Node423 i_26;
Node451 j0_27;
Node452 j1_31;
Node453 j1_30;
Node454 r_3;
Node455 c_27;
Node456 i_27;
Node457 j1_29;
equation
 connect(sesf_1.Port3,j1_0.Port2);
 connect(j0_3.Port10,j1_31.Port9);
 connect(j1_31.Port13,j0_27.Port12);
 connect(j1_31.Port16,j0_5.Port15);
 connect(j0_5.Port19,j1_36.Port18);
 connect(j1_36.Port22,c_8.Port21);
 connect(j1_36.Port25,r_7.Port24);
 connect(j0_5.Port27,i_27.Port461);
 connect(j1_0.Port155,i_4.Port154);
 connect(j0_1.Port158,j1_0.Port157);
 connect(msf_12.Port167,j0_3.Port166);
 connect(function_13.Port170,msf_12.Port169);
 connect(j0_3.Port173,j1_11.Port172);
 connect(j1_11.Port179,r_11.Port178);
 connect(j0_1.Port182,j1_6.Port181);
 connect(j1_6.Port185,c_7.Port184);
 connect(se_15.Port202,j1_0.Port201);
 connect(j1_6.Port245,r_0.Port244);
 connect(j1_11.Port249,dedf_1.Port248);
 connect(j1_2.Port301,i_14.Port300);
 connect(j1_2.Port304,j0_1.Port303);
 connect(j0_6.Port317,j1_2.Port316);
 connect(j0_6.Port365,j1_20.Port364);
 connect(j1_20.Port368,r_4.Port367);
 connect(j1_20.Port371,c_5.Port370);
 connect(j0_25.Port400,j1_26.Port399);
 connect(j1_26.Port403,r_25.Port402);
 connect(j1_26.Port406,c_25.Port405);
 connect(j0_25.Port409,j1_25.Port408);
 connect(j1_25.Port412,i_6.Port411);
 connect(j1_25.Port415,j0_6.Port414);
 connect(j0_26.Port434,j1_28.Port433);
 connect(j1_28.Port437,r_26.Port436);
 connect(j1_28.Port440,c_26.Port439);
 connect(j0_26.Port443,j1_27.Port442);
 connect(j1_27.Port446,i_25.Port445);
 connect(j1_27.Port449,j0_25.Port448);
 connect(j0_27.Port468,j1_30.Port467);
 connect(j1_30.Port471,r_3.Port470);
 connect(j1_30.Port474,c_27.Port473);
 connect(j0_27.Port477,j1_29.Port476);
 connect(j1_29.Port480,i_26.Port479);
 connect(j1_29.Port483,j0_26.Port482);
end modele53a_4RC;
